/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@wordpress/hooks/build-module/createAddHook.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createAddHook.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _validateNamespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validateNamespace.js */ "./node_modules/@wordpress/hooks/build-module/validateNamespace.js");
/* harmony import */ var _validateHookName_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./validateHookName.js */ "./node_modules/@wordpress/hooks/build-module/validateHookName.js");
/**
 * Internal dependencies
 */



/**
 * @callback AddHook
 *
 * Adds the hook to the appropriate hooks container.
 *
 * @param {string}               hookName      Name of hook to add
 * @param {string}               namespace     The unique namespace identifying the callback in the form `vendor/plugin/function`.
 * @param {import('.').Callback} callback      Function to call when the hook is run
 * @param {number}               [priority=10] Priority of this hook
 */

/**
 * Returns a function which, when invoked, will add a hook.
 *
 * @param {import('.').Hooks}    hooks    Hooks instance.
 * @param {import('.').StoreKey} storeKey
 *
 * @return {AddHook} Function that adds a new hook.
 */
function createAddHook(hooks, storeKey) {
  return function addHook(hookName, namespace, callback, priority = 10) {
    const hooksStore = hooks[storeKey];
    if (!(0,_validateHookName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(hookName)) {
      return;
    }
    if (!(0,_validateNamespace_js__WEBPACK_IMPORTED_MODULE_0__["default"])(namespace)) {
      return;
    }
    if ('function' !== typeof callback) {
      // eslint-disable-next-line no-console
      console.error('The hook callback must be a function.');
      return;
    }

    // Validate numeric priority
    if ('number' !== typeof priority) {
      // eslint-disable-next-line no-console
      console.error('If specified, the hook priority must be a number.');
      return;
    }
    const handler = {
      callback,
      priority,
      namespace
    };
    if (hooksStore[hookName]) {
      // Find the correct insert index of the new hook.
      const handlers = hooksStore[hookName].handlers;

      /** @type {number} */
      let i;
      for (i = handlers.length; i > 0; i--) {
        if (priority >= handlers[i - 1].priority) {
          break;
        }
      }
      if (i === handlers.length) {
        // If append, operate via direct assignment.
        handlers[i] = handler;
      } else {
        // Otherwise, insert before index via splice.
        handlers.splice(i, 0, handler);
      }

      // We may also be currently executing this hook.  If the callback
      // we're adding would come after the current callback, there's no
      // problem; otherwise we need to increase the execution index of
      // any other runs by 1 to account for the added element.
      hooksStore.__current.forEach(hookInfo => {
        if (hookInfo.name === hookName && hookInfo.currentIndex >= i) {
          hookInfo.currentIndex++;
        }
      });
    } else {
      // This is the first hook of its type.
      hooksStore[hookName] = {
        handlers: [handler],
        runs: 0
      };
    }
    if (hookName !== 'hookAdded') {
      hooks.doAction('hookAdded', hookName, namespace, callback, priority);
    }
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createAddHook);
//# sourceMappingURL=createAddHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createCurrentHook.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createCurrentHook.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Returns a function which, when invoked, will return the name of the
 * currently running hook, or `null` if no hook of the given type is currently
 * running.
 *
 * @param {import('.').Hooks}    hooks    Hooks instance.
 * @param {import('.').StoreKey} storeKey
 *
 * @return {() => string | null} Function that returns the current hook name or null.
 */
function createCurrentHook(hooks, storeKey) {
  return function currentHook() {
    var _hooksStore$__current;
    const hooksStore = hooks[storeKey];
    return (_hooksStore$__current = hooksStore.__current[hooksStore.__current.length - 1]?.name) !== null && _hooksStore$__current !== void 0 ? _hooksStore$__current : null;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createCurrentHook);
//# sourceMappingURL=createCurrentHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createDidHook.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createDidHook.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _validateHookName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validateHookName.js */ "./node_modules/@wordpress/hooks/build-module/validateHookName.js");
/**
 * Internal dependencies
 */


/**
 * @callback DidHook
 *
 * Returns the number of times an action has been fired.
 *
 * @param {string} hookName The hook name to check.
 *
 * @return {number | undefined} The number of times the hook has run.
 */

/**
 * Returns a function which, when invoked, will return the number of times a
 * hook has been called.
 *
 * @param {import('.').Hooks}    hooks    Hooks instance.
 * @param {import('.').StoreKey} storeKey
 *
 * @return {DidHook} Function that returns a hook's call count.
 */
function createDidHook(hooks, storeKey) {
  return function didHook(hookName) {
    const hooksStore = hooks[storeKey];
    if (!(0,_validateHookName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(hookName)) {
      return;
    }
    return hooksStore[hookName] && hooksStore[hookName].runs ? hooksStore[hookName].runs : 0;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createDidHook);
//# sourceMappingURL=createDidHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createDoingHook.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createDoingHook.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @callback DoingHook
 * Returns whether a hook is currently being executed.
 *
 * @param {string} [hookName] The name of the hook to check for.  If
 *                            omitted, will check for any hook being executed.
 *
 * @return {boolean} Whether the hook is being executed.
 */

/**
 * Returns a function which, when invoked, will return whether a hook is
 * currently being executed.
 *
 * @param {import('.').Hooks}    hooks    Hooks instance.
 * @param {import('.').StoreKey} storeKey
 *
 * @return {DoingHook} Function that returns whether a hook is currently
 *                     being executed.
 */
function createDoingHook(hooks, storeKey) {
  return function doingHook(hookName) {
    const hooksStore = hooks[storeKey];

    // If the hookName was not passed, check for any current hook.
    if ('undefined' === typeof hookName) {
      return 'undefined' !== typeof hooksStore.__current[0];
    }

    // Return the __current hook.
    return hooksStore.__current[0] ? hookName === hooksStore.__current[0].name : false;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createDoingHook);
//# sourceMappingURL=createDoingHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createHasHook.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createHasHook.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @callback HasHook
 *
 * Returns whether any handlers are attached for the given hookName and optional namespace.
 *
 * @param {string} hookName    The name of the hook to check for.
 * @param {string} [namespace] Optional. The unique namespace identifying the callback
 *                             in the form `vendor/plugin/function`.
 *
 * @return {boolean} Whether there are handlers that are attached to the given hook.
 */
/**
 * Returns a function which, when invoked, will return whether any handlers are
 * attached to a particular hook.
 *
 * @param {import('.').Hooks}    hooks    Hooks instance.
 * @param {import('.').StoreKey} storeKey
 *
 * @return {HasHook} Function that returns whether any handlers are
 *                   attached to a particular hook and optional namespace.
 */
function createHasHook(hooks, storeKey) {
  return function hasHook(hookName, namespace) {
    const hooksStore = hooks[storeKey];

    // Use the namespace if provided.
    if ('undefined' !== typeof namespace) {
      return hookName in hooksStore && hooksStore[hookName].handlers.some(hook => hook.namespace === namespace);
    }
    return hookName in hooksStore;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createHasHook);
//# sourceMappingURL=createHasHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createHooks.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createHooks.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _Hooks: () => (/* binding */ _Hooks),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _createAddHook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createAddHook */ "./node_modules/@wordpress/hooks/build-module/createAddHook.js");
/* harmony import */ var _createRemoveHook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createRemoveHook */ "./node_modules/@wordpress/hooks/build-module/createRemoveHook.js");
/* harmony import */ var _createHasHook__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createHasHook */ "./node_modules/@wordpress/hooks/build-module/createHasHook.js");
/* harmony import */ var _createRunHook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./createRunHook */ "./node_modules/@wordpress/hooks/build-module/createRunHook.js");
/* harmony import */ var _createCurrentHook__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./createCurrentHook */ "./node_modules/@wordpress/hooks/build-module/createCurrentHook.js");
/* harmony import */ var _createDoingHook__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./createDoingHook */ "./node_modules/@wordpress/hooks/build-module/createDoingHook.js");
/* harmony import */ var _createDidHook__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./createDidHook */ "./node_modules/@wordpress/hooks/build-module/createDidHook.js");
/**
 * Internal dependencies
 */








/**
 * Internal class for constructing hooks. Use `createHooks()` function
 *
 * Note, it is necessary to expose this class to make its type public.
 *
 * @private
 */
class _Hooks {
  constructor() {
    /** @type {import('.').Store} actions */
    this.actions = Object.create(null);
    this.actions.__current = [];

    /** @type {import('.').Store} filters */
    this.filters = Object.create(null);
    this.filters.__current = [];
    this.addAction = (0,_createAddHook__WEBPACK_IMPORTED_MODULE_0__["default"])(this, 'actions');
    this.addFilter = (0,_createAddHook__WEBPACK_IMPORTED_MODULE_0__["default"])(this, 'filters');
    this.removeAction = (0,_createRemoveHook__WEBPACK_IMPORTED_MODULE_1__["default"])(this, 'actions');
    this.removeFilter = (0,_createRemoveHook__WEBPACK_IMPORTED_MODULE_1__["default"])(this, 'filters');
    this.hasAction = (0,_createHasHook__WEBPACK_IMPORTED_MODULE_2__["default"])(this, 'actions');
    this.hasFilter = (0,_createHasHook__WEBPACK_IMPORTED_MODULE_2__["default"])(this, 'filters');
    this.removeAllActions = (0,_createRemoveHook__WEBPACK_IMPORTED_MODULE_1__["default"])(this, 'actions', true);
    this.removeAllFilters = (0,_createRemoveHook__WEBPACK_IMPORTED_MODULE_1__["default"])(this, 'filters', true);
    this.doAction = (0,_createRunHook__WEBPACK_IMPORTED_MODULE_3__["default"])(this, 'actions');
    this.applyFilters = (0,_createRunHook__WEBPACK_IMPORTED_MODULE_3__["default"])(this, 'filters', true);
    this.currentAction = (0,_createCurrentHook__WEBPACK_IMPORTED_MODULE_4__["default"])(this, 'actions');
    this.currentFilter = (0,_createCurrentHook__WEBPACK_IMPORTED_MODULE_4__["default"])(this, 'filters');
    this.doingAction = (0,_createDoingHook__WEBPACK_IMPORTED_MODULE_5__["default"])(this, 'actions');
    this.doingFilter = (0,_createDoingHook__WEBPACK_IMPORTED_MODULE_5__["default"])(this, 'filters');
    this.didAction = (0,_createDidHook__WEBPACK_IMPORTED_MODULE_6__["default"])(this, 'actions');
    this.didFilter = (0,_createDidHook__WEBPACK_IMPORTED_MODULE_6__["default"])(this, 'filters');
  }
}

/** @typedef {_Hooks} Hooks */

/**
 * Returns an instance of the hooks object.
 *
 * @return {Hooks} A Hooks instance.
 */
function createHooks() {
  return new _Hooks();
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createHooks);
//# sourceMappingURL=createHooks.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createRemoveHook.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createRemoveHook.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _validateNamespace_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validateNamespace.js */ "./node_modules/@wordpress/hooks/build-module/validateNamespace.js");
/* harmony import */ var _validateHookName_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./validateHookName.js */ "./node_modules/@wordpress/hooks/build-module/validateHookName.js");
/**
 * Internal dependencies
 */



/**
 * @callback RemoveHook
 * Removes the specified callback (or all callbacks) from the hook with a given hookName
 * and namespace.
 *
 * @param {string} hookName  The name of the hook to modify.
 * @param {string} namespace The unique namespace identifying the callback in the
 *                           form `vendor/plugin/function`.
 *
 * @return {number | undefined} The number of callbacks removed.
 */

/**
 * Returns a function which, when invoked, will remove a specified hook or all
 * hooks by the given name.
 *
 * @param {import('.').Hooks}    hooks             Hooks instance.
 * @param {import('.').StoreKey} storeKey
 * @param {boolean}              [removeAll=false] Whether to remove all callbacks for a hookName,
 *                                                 without regard to namespace. Used to create
 *                                                 `removeAll*` functions.
 *
 * @return {RemoveHook} Function that removes hooks.
 */
function createRemoveHook(hooks, storeKey, removeAll = false) {
  return function removeHook(hookName, namespace) {
    const hooksStore = hooks[storeKey];
    if (!(0,_validateHookName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(hookName)) {
      return;
    }
    if (!removeAll && !(0,_validateNamespace_js__WEBPACK_IMPORTED_MODULE_0__["default"])(namespace)) {
      return;
    }

    // Bail if no hooks exist by this name.
    if (!hooksStore[hookName]) {
      return 0;
    }
    let handlersRemoved = 0;
    if (removeAll) {
      handlersRemoved = hooksStore[hookName].handlers.length;
      hooksStore[hookName] = {
        runs: hooksStore[hookName].runs,
        handlers: []
      };
    } else {
      // Try to find the specified callback to remove.
      const handlers = hooksStore[hookName].handlers;
      for (let i = handlers.length - 1; i >= 0; i--) {
        if (handlers[i].namespace === namespace) {
          handlers.splice(i, 1);
          handlersRemoved++;
          // This callback may also be part of a hook that is
          // currently executing.  If the callback we're removing
          // comes after the current callback, there's no problem;
          // otherwise we need to decrease the execution index of any
          // other runs by 1 to account for the removed element.
          hooksStore.__current.forEach(hookInfo => {
            if (hookInfo.name === hookName && hookInfo.currentIndex >= i) {
              hookInfo.currentIndex--;
            }
          });
        }
      }
    }
    if (hookName !== 'hookRemoved') {
      hooks.doAction('hookRemoved', hookName, namespace);
    }
    return handlersRemoved;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createRemoveHook);
//# sourceMappingURL=createRemoveHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/createRunHook.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/createRunHook.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Returns a function which, when invoked, will execute all callbacks
 * registered to a hook of the specified type, optionally returning the final
 * value of the call chain.
 *
 * @param {import('.').Hooks}    hooks                  Hooks instance.
 * @param {import('.').StoreKey} storeKey
 * @param {boolean}              [returnFirstArg=false] Whether each hook callback is expected to
 *                                                      return its first argument.
 *
 * @return {(hookName:string, ...args: unknown[]) => undefined|unknown} Function that runs hook callbacks.
 */
function createRunHook(hooks, storeKey, returnFirstArg = false) {
  return function runHooks(hookName, ...args) {
    const hooksStore = hooks[storeKey];
    if (!hooksStore[hookName]) {
      hooksStore[hookName] = {
        handlers: [],
        runs: 0
      };
    }
    hooksStore[hookName].runs++;
    const handlers = hooksStore[hookName].handlers;

    // The following code is stripped from production builds.
    if (true) {
      // Handle any 'all' hooks registered.
      if ('hookAdded' !== hookName && hooksStore.all) {
        handlers.push(...hooksStore.all.handlers);
      }
    }
    if (!handlers || !handlers.length) {
      return returnFirstArg ? args[0] : undefined;
    }
    const hookInfo = {
      name: hookName,
      currentIndex: 0
    };
    hooksStore.__current.push(hookInfo);
    while (hookInfo.currentIndex < handlers.length) {
      const handler = handlers[hookInfo.currentIndex];
      const result = handler.callback.apply(null, args);
      if (returnFirstArg) {
        args[0] = result;
      }
      hookInfo.currentIndex++;
    }
    hooksStore.__current.pop();
    if (returnFirstArg) {
      return args[0];
    }
    return undefined;
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createRunHook);
//# sourceMappingURL=createRunHook.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/index.js":
/*!*************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   actions: () => (/* binding */ actions),
/* harmony export */   addAction: () => (/* binding */ addAction),
/* harmony export */   addFilter: () => (/* binding */ addFilter),
/* harmony export */   applyFilters: () => (/* binding */ applyFilters),
/* harmony export */   createHooks: () => (/* reexport safe */ _createHooks__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   currentAction: () => (/* binding */ currentAction),
/* harmony export */   currentFilter: () => (/* binding */ currentFilter),
/* harmony export */   defaultHooks: () => (/* binding */ defaultHooks),
/* harmony export */   didAction: () => (/* binding */ didAction),
/* harmony export */   didFilter: () => (/* binding */ didFilter),
/* harmony export */   doAction: () => (/* binding */ doAction),
/* harmony export */   doingAction: () => (/* binding */ doingAction),
/* harmony export */   doingFilter: () => (/* binding */ doingFilter),
/* harmony export */   filters: () => (/* binding */ filters),
/* harmony export */   hasAction: () => (/* binding */ hasAction),
/* harmony export */   hasFilter: () => (/* binding */ hasFilter),
/* harmony export */   removeAction: () => (/* binding */ removeAction),
/* harmony export */   removeAllActions: () => (/* binding */ removeAllActions),
/* harmony export */   removeAllFilters: () => (/* binding */ removeAllFilters),
/* harmony export */   removeFilter: () => (/* binding */ removeFilter)
/* harmony export */ });
/* harmony import */ var _createHooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createHooks */ "./node_modules/@wordpress/hooks/build-module/createHooks.js");
/**
 * Internal dependencies
 */


/** @typedef {(...args: any[])=>any} Callback */

/**
 * @typedef Handler
 * @property {Callback} callback  The callback
 * @property {string}   namespace The namespace
 * @property {number}   priority  The namespace
 */

/**
 * @typedef Hook
 * @property {Handler[]} handlers Array of handlers
 * @property {number}    runs     Run counter
 */

/**
 * @typedef Current
 * @property {string} name         Hook name
 * @property {number} currentIndex The index
 */

/**
 * @typedef {Record<string, Hook> & {__current: Current[]}} Store
 */

/**
 * @typedef {'actions' | 'filters'} StoreKey
 */

/**
 * @typedef {import('./createHooks').Hooks} Hooks
 */

const defaultHooks = (0,_createHooks__WEBPACK_IMPORTED_MODULE_0__["default"])();
const {
  addAction,
  addFilter,
  removeAction,
  removeFilter,
  hasAction,
  hasFilter,
  removeAllActions,
  removeAllFilters,
  doAction,
  applyFilters,
  currentAction,
  currentFilter,
  doingAction,
  doingFilter,
  didAction,
  didFilter,
  actions,
  filters
} = defaultHooks;

//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/validateHookName.js":
/*!************************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/validateHookName.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Validate a hookName string.
 *
 * @param {string} hookName The hook name to validate. Should be a non empty string containing
 *                          only numbers, letters, dashes, periods and underscores. Also,
 *                          the hook name cannot begin with `__`.
 *
 * @return {boolean} Whether the hook name is valid.
 */
function validateHookName(hookName) {
  if ('string' !== typeof hookName || '' === hookName) {
    // eslint-disable-next-line no-console
    console.error('The hook name must be a non-empty string.');
    return false;
  }
  if (/^__/.test(hookName)) {
    // eslint-disable-next-line no-console
    console.error('The hook name cannot begin with `__`.');
    return false;
  }
  if (!/^[a-zA-Z][a-zA-Z0-9_.-]*$/.test(hookName)) {
    // eslint-disable-next-line no-console
    console.error('The hook name can only contain numbers, letters, dashes, periods and underscores.');
    return false;
  }
  return true;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (validateHookName);
//# sourceMappingURL=validateHookName.js.map

/***/ }),

/***/ "./node_modules/@wordpress/hooks/build-module/validateNamespace.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@wordpress/hooks/build-module/validateNamespace.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Validate a namespace string.
 *
 * @param {string} namespace The namespace to validate - should take the form
 *                           `vendor/plugin/function`.
 *
 * @return {boolean} Whether the namespace is valid.
 */
function validateNamespace(namespace) {
  if ('string' !== typeof namespace || '' === namespace) {
    // eslint-disable-next-line no-console
    console.error('The namespace must be a non-empty string.');
    return false;
  }
  if (!/^[a-zA-Z][a-zA-Z0-9_.\-\/]*$/.test(namespace)) {
    // eslint-disable-next-line no-console
    console.error('The namespace can only contain numbers, letters, dashes, periods, underscores and slashes.');
    return false;
  }
  return true;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (validateNamespace);
//# sourceMappingURL=validateNamespace.js.map

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/*!***************************!*\
  !*** ./assets/js/main.js ***!
  \***************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/hooks */ "./node_modules/@wordpress/hooks/build-module/index.js");

window.SB_Customizer = {
  extraMethods: {},
  extraData: {}
};
SB_Customizer.hooks = (0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_0__.createHooks)();
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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